unit SetupFormUnit;
{
    UNIT SetupFormUnit;
    Version number 1.0.

This unit contains 'pBoy's YAFTP > Preferences' form and it's handling routines.

Created by Pter Karsai }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, TabNotBk, ExtCtrls, ComCtrls, FTPCacheManager;

const
  ICloseQuery : boolean = false;
  { TRUE if AcceptButtonClick() called from onCloseQuery() form event. When
  AcceptButtonClick() finished, TRUE if form can be closed }

{ setup information record type }
type SetupRecord = record
     sEmailAddr  : string;   { e-mail address }
     sWantCache  : boolean;  { TRUE if cacheing enabled }
     sGCStartup  : boolean;  { TRUE if we have to start garbage c. on startup }
     sExpDays    : word;     { number of days to expiration }
     sConnectTO  : word;     { connection timeout }
     sWelcomeTO  : word;     { welcome message timeout }
     sReplyTO    : word;     { server reply timeout }
     sNOOPSecs   : word;     { number of seconds between NOOPs }
     sRetSrvUnr  : word;     { number of retries if server unreachable }
     sRetLogFail : word;     { number of retries if login failed }
     sDelayBRet  : word;     { delay between retries }
     sAutoTrn    : byte;     { auto-transfer set: 0 - if filesize smaller,
                               1 - always overwrite, 2 - never use same name }
end;

{ default values for SetupData record }
const DefaultSetup : SetupRecord =
    (sEmailAddr  : 'trashed@dont.bother.me.net'; sWantCache  : TRUE;
     sGCStartup  : TRUE; sExpDays    : 8;
     sConnectTO  : 120;  sWelcomeTO  : 120; sReplyTO    : 120;
     sNOOPSecs   : 30;   sRetSrvUnr  : 5;   sRetLogFail : 25;
     sDelayBRet  : 5;    sAutoTrn    : 0);

{ form TSetupForm class declaration }
type
  TSetupForm = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    GroupBox1: TGroupBox; GroupBox2: TGroupBox; GroupBox3: TGroupBox;
    GroupBox4: TGroupBox; GroupBox5: TGroupBox;
    EmptyCacheButton : TButton; StartGCButton    : TButton;
    AcceptButton     : TButton; CancelButton     : TButton;
    HelpButton       : TButton; ResetButton      : TButton;
    WantCacheChkBox  : TCheckBox; GCOnStartupChkBox : TCheckBox;
    Label1 : TLabel; Label2 : TLabel; Label3 : TLabel; Label4 : TLabel;
    Label5 : TLabel; Label6 : TLabel; Label7 : TLabel; Label8 : TLabel;
    Label9 : TLabel; Label10: TLabel; Label11: TLabel; Label12: TLabel;
    Label13: TLabel; Label14: TLabel; Label15: TLabel;
    AnonEmailEdit   : TEdit; ExpDaysEdit     : TEdit;
    CTimeOutEdit    : TEdit; WTimeOutEdit    : TEdit;
    RTimeOutEdit    : TEdit; NOOPSecsEdit    : TEdit;
    RSrvUnReachEdit : TEdit; LFailRetEdit    : TEdit;
    DelayBRetEdit   : TEdit;
    AutoRadioGroup  : TRadioGroup;

{ event handlers in TSetupForm }
    procedure AcceptButtonClick(Sender: TObject);   { checker & saver for data }
    procedure CancelButtonClick(Sender: TObject);   { discard changes }
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean); { check }
    procedure ResetButtonClick(Sender: TObject);      { reset to defaults }
    procedure EmptyCacheButtonClick(Sender: TObject); { cache clean }
    procedure StartGCButtonClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);  { garbage collector button }
  public
 { public SetupData contains the settings }
    SetupData : SetupRecord;

    procedure ResetToDefaults;
{ Function: reset setup data (SetupData) from DefaultSetup constant-record. }

    procedure LoadData;
{ Function: load SetupData information to the form. }
  end;

{------------------------------------------------------------------------------}
function IsCorrectNumber(LowVal, HighVal: longint; Msg, Num: string) : boolean;

var SetupForm: TSetupForm;

implementation

uses FTPFormUnit;

{$R *.DFM}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
{------ TSetupForm class event handlers and other methods ---------------------}
{------------------------------------------------------------------------------}
{------------------------------------------------------------------------------}
function IsCorrectNumber(LowVal, HighVal: longint; Msg, Num: string) : boolean;
var tempStr : string; { temporary string for store outgoing message }
    tempNTS : array[1..1024] of char; { pchar storage }
    tempNum : longint; { temporary (conversion) variable }
begin
    Result:= true;  { we start with no errors }
{ try to convert incoming string to number }
    try
       tempNum:= StrToInt(Num)
    except
       on EConvertError do Result:= false;
    end;

{ check value of incoming number }
    if not Result or (tempNum < LowVal) or (tempNum > HighVal) then
    begin
    { prepare message }
        tempStr:= Format('Please enter a number between %d and %d!'#10#13,
                         [LowVal, HighVal]);
        if Msg <> '' then tempStr:= tempStr + #10#13 + Msg;
        StrPCopy(@tempNTS, tempStr);  { convert to PChar }
    { show message window }
        Application.MessageBox(@tempNTS, 'YAFTP > Number error', mb_OK +
                               mb_IconExclamation);
        Result:= false;
    end;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.ResetToDefaults;
begin
    SetupData:= DefaultSetup;  { load defaults }
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.LoadData;
begin
{ load all data back to form edit }
    AnonEmailEdit.Text        := SetupData.sEmailAddr;
    WantCacheChkBox.Checked   := SetupData.sWantCache;
    ExpDaysEdit.Text          := IntToStr(SetupData.sExpDays);
    GCOnStartupChkBox.Checked := SetupData.sGCStartup;
    CTimeOutEdit.Text         := IntToStr(SetupData.sConnectTO);
    WTimeOutEdit.Text         := IntToStr(SetupData.sWelcomeTO);
    RTimeOutEdit.Text         := IntToStr(SetupData.sReplyTO);
    NOOPSecsEdit.Text         := IntToStr(SetupData.sNOOPSecs);
    RSrvUnReachEdit.Text      := IntToStr(SetupData.sRetSrvUnr);
    LFailRetEdit.Text         := IntToStr(SetupData.sRetLogFail);
    DelayBRetEdit.Text        := IntToStr(SetupData.sDelayBRet);
    AutoRadioGroup.ItemIndex  := SetupData.sAutoTrn;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.AcceptButtonClick(Sender: TObject);
var wasError: boolean;     { TRUE if an error occur }
    focusTo : TWinControl; { component to focus to (where error occured) }
    pageTo  : string;      { page where error occur }
begin
    wasError:= false;
{ check e-mail address }
    if Pos('@', AnonEmailEdit.Text) = 0 then
    begin
        Application.MessageBox('Invalid e-mail address.','YAFTP > Syntax error',
                               MB_OK + Mb_ICONEXCLAMATION);
        wasError:= true;
        focusTo:= AnonEmailEdit;
        pageTo:= 'General';
    end;

{ check expiration value }
    if not IsCorrectNumber(0, 255,'The recommended value is 8 days.',
                                   ExpDaysEdit.Text) and not wasError then begin
                                   wasError:= true; focusTo:= ExpDaysEdit;
                                   pageTo:= 'General' end;
{ check timeout values }
    if not IsCorrectNumber(1, 360,'The recommended value is 60 seconds.',
                                  CTimeOutEdit.Text) and not wasError then begin
                                  wasError:= true; focusTo:= CTimeOutEdit;
                                  pageTo:= 'Advanced' end;
    if not IsCorrectNumber(1, 360,'The recommended value is 60 seconds.',
                                  WTimeOutEdit.Text) and not wasError then begin
                                  wasError:= true; focusTo:= WTimeOutEdit;
                                  pageTo:= 'Advanced' end;
    if not IsCorrectNumber(1, 360,'The recommended value is 60 seconds.',
                                  RTimeOutEdit.Text) and not wasError then begin
                                  wasError:= true; focusTo:= RTimeOutEdit;
                                  pageTo:= 'Advanced' end;
{ check NOOP secs }
    if not IsCorrectNumber(1, 360,'The recommended value is 30 seconds.',
                                  NOOPSecsEdit.Text) and not wasError then begin
                                  wasError:= true; focusTo:= NOOPSecsEdit;
                                  pageTo:= 'Advanced' end;
{ check retry values }
    if not IsCorrectNumber(1, 60,'The recommended value is 5 retries.',
                               RSrvUnReachEdit.Text) and not wasError then begin
                                 wasError:= true; focusTo:= RSrvUnReachEdit;
                                 pageTo:= 'Advanced' end;
    if not IsCorrectNumber(1, 60,'The recommended value is 25 retries.',
                                  LFailRetEdit.Text) and not wasError then begin
                                  wasError:= true; focusTo:= LFailRetEdit;
                                  pageTo:= 'Advanced' end;
    if not IsCorrectNumber(1, 60,'The recommended value is 5 seconds.',
                                 DelayBRetEdit.Text) and not wasError then begin
                                 wasError:= true; focusTo:= DelayBRetEdit;
                                 pageTo:= 'Advanced' end;

{ show bad value edit to user }
    if wasError then
    begin
       TabbedNotebook1.ActivePage:= pageTo;  { set page where bad value is }
       focusTo.SetFocus;    { set focus to the bad value }
       ICloseQuery:= false  { not to close form while bad values entered! }
    end;

{ save settings if there was no error }
    if not wasError then
       with SetupData do begin
          sEmailAddr := AnonEmailEdit.Text;        { e-mail address }
          sWantCache := WantCacheChkBox.Checked;   { cacheing enabled/disabled }
          sGCStartUp := GCOnStartupChkBox.Checked; { garbage collector }
          sExpDays   := StrToInt(ExpDaysEdit.Text);{ expiration }
          sConnectTO := StrToInt(CTimeOutEdit.Text);   { timeout - connecting }
          sWelcomeTO := StrToInt(WTimeOutEdit.Text);   { timeout - welcome msg }
          sReplyTO   := StrToInt(RTimeOutEdit.Text);   { timeout - reply msg }
          sNOOPSecs  := StrToInt(NOOPSecsEdit.Text);   { NOOP seconds }
          sRetSrvUnr := StrToInt(RSrvUnReachEdit.Text);{ retries if unreach. }
          sRetLogFail:= StrToInt(LFailRetEdit.Text);  { retries on login fail }
          sDelayBRet := StrToInt(DelayBRetEdit.Text); { delay between retries }
          sAutoTrn   := AutoRadioGroup.ItemIndex;     { yeah guess what }
          { oh yeah it's such a perfect day / i'm glad i spent it with you /
            oh such a perfect day / you keep me hangin' on... :)
            you're goin' to reap what you sow... you're goin' to reap... :))
            Something about the developement: I'm sittin' in my chair, using
            my friend's Celeron to do this stuff. Moreover, i'm listenin' to
            one of my MP3 CDs... and I like this song :) Now change to SNOG! }

       { save initial settings }
          FTPFTools.SaveInitSettings;
       { close form if it not called by onCloseQuery form event }
          if not ICloseQuery then SetupForm.Close;
       end;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.CancelButtonClick(Sender: TObject);
begin
     SetupForm.Close;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
{ close form if all data is correct }
     ICloseQuery:= true;
     AcceptButtonClick(nil);  { save data }
     CanClose:= ICloseQuery;  { close if all data was correct }
     ICloseQuery:= false;     { switch to default state }
     FTPForm.Enabled:= true;  { enable main form }
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.ResetButtonClick(Sender: TObject);
begin
     ResetToDefaults;  { load default values }
     LoadData;         { show values }
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.EmptyCacheButtonClick(Sender: TObject);
var tempFTPCache: TFTPCache;  { FTP cache manager }
    tempReturn  : byte;       { cmX* returning value }
begin
{ try to empty cache }
    tempFTPCache:= TFTPCache.Create(FTPForm.CacheDir, '0.0.0.0', 0);
    tempReturn:= tempFTPCache.EmptyCache;  { try to empty cache }
{ if there was an error while emptying... }
    if tempReturn <> cmNO_ERROR then
       Application.MessageBox(cmMessages[tempReturn], 'YAFTP > Cache error',
                              mb_OK + mb_IconWarning)
    else
       Application.MessageBox('Now the cache is empty.', 'YAFTP > Information',
                              mb_OK + mb_IconInformation);
{ free FTP cache manager }
    tempFTPCache.Free;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.StartGCButtonClick(Sender: TObject);
var tempFTPCache: TFTPCache;  { FTP cache manager }
    tempReturn  : byte;       { cmX* returning value }
    tempStr     : string;     { string stores caption of StartGCButton }
begin
{ create cache manager }
    tempFTPCache:= TFTPCache.Create(FTPForm.CacheDir, '0.0.0.0',
                                    SetupData.sExpDays);
{ show collecting state }
    tempStr:= StartGCButton.Caption; StartGCButton.Caption:= 'Collecting...';
{ run garbage collector }
    tempReturn:= tempFTPCache.GarbageCollector;  { run garbage collector }
    StartGCButton.Caption:= tempStr;  { restore original caption }

{ if there was an error while emptying... }
    if tempReturn <> cmNO_ERROR then
       Application.MessageBox(cmMessages[tempReturn], 'YAFTP > Cache error',
                              mb_OK + mb_IconWarning)
    else
       Application.MessageBox('Garbage collection was successful.'#10+
                          'All expired entries removed.'#10#10+
                          'JULES: Vincent! We happy? We happy?!'#10+
                          'VINCENT: We''re happy :)', 'YAFTP > Information',
                           mb_OK + mb_IconInformation);
{ free FTP cache manager }
    tempFTPCache.Free;
end;

{------------------------------------------------------------------------------}

procedure TSetupForm.HelpButtonClick(Sender: TObject);
begin
     Application.HelpCommand(HELP_CONTEXT, $41);
end;

end.
